#!/usr/bin/env bash


cat /hive-config/wallet.conf > wallet.conf
# Extract the line, remove quotes, and split
template=$(grep '^CUSTOM_TEMPLATE=' /hive-config/wallet.conf | cut -d'=' -f2 | tr -d '"')
# template now contains: ASDADASDASDASD.Worker

USERNAME=$(echo "$template" | cut -d'.' -f1)
WORKER=$(echo "$template" | cut -d'.' -f2)

echo "Username: $USERNAME" > setup.txt
echo "Worker: $WORKER" >> setup.txt

PASS=$(grep '^CUSTOM_PASS=' /hive-config/wallet.conf | awk -F'=' '{print substr($0, index($0,$2))}' | tr -d '"')
echo "Password: $PASS" >> setup.txt

EXTRA_CONFIG=$(grep '^CUSTOM_USER_CONFIG=' /hive-config/wallet.conf | awk -F= '{print $2}' | sed -e s/\'//g )
echo "Extra config: $EXTRA_CONFIG" >> setup.txt


CUSTOM_URL=$(grep '^CUSTOM_URL=' /hive-config/wallet.conf | cut -d'=' -f2 | tr -d '"')
echo "Custom URL: $CUSTOM_URL" >> setup.txt


HOO_CPU_ARGS=" -o $CUSTOM_URL -u $USERNAME.$WORKER -p $PASS $EXTRA_CONFIG "

echo "Whole string to pass as args $HOO_CPU_ARGS" >> setup.txt
