#!/bin/bash
# Runs Hoominer, Hoo-CPU, and Hoo-GPU in parallel in separate screen sessions with appended worker names (_minername)

. h-manifest.conf

mkdir -p "$(dirname "$CUSTOM_LOG_BASENAME.log")" && touch "$CUSTOM_LOG_BASENAME.log"

CONFIG_CONTENTS=$(< "$CUSTOM_CONFIG_FILENAME")

set_worker_name() {
    local config="$1"
    local miner_name="$2"

    # Critical fix: printf emits real newlines → sed sees lines
    printf '%s\n' "$config" | sed -E \
        -e "s/(--user[[:space:]]+hoosat:[0-9a-fA-F]{61}\.)([^[:space:]]+)/\1\2_${miner_name}/g" \
        -e "s/(--user[[:space:]]+hoosat:[0-9a-fA-F]{61})([[:space:]]|$)/\1.${miner_name}\2/g"
}

# --- Run miners in parallel ---
if [[ "$CONFIG_CONTENTS" == *"--hoominer"* ]]; then
    hoominer_config=$(set_worker_name "$CONFIG_CONTENTS" "hoominer")
    ./hoominer $hoominer_config &
fi

if [[ "$CONFIG_CONTENTS" == *"--hoo_cpu"* ]]; then
    hoo_cpu_config=$(set_worker_name "$CONFIG_CONTENTS" "hoo_cpu")
    ./hoo_cpu $hoo_cpu_config &
fi

if [[ "$CONFIG_CONTENTS" == *"--hoo_gpu"* ]]; then
    hoo_gpu_config=$(set_worker_name "$CONFIG_CONTENTS" "hoo_gpu")
    ./hoo_gpu $hoo_gpu_config &
fi

wait  # Wait for all background processes to finish
