#!/bin/bash
# Runs Hoominer, Hoo-CPU, and Hoo-GPU in parallel in separate screen sessions with modified parameters

. h-manifest.conf

mkdir -p "$(dirname "$CUSTOM_LOG_BASENAME.log")" && touch "$CUSTOM_LOG_BASENAME.log"

CONFIG_CONTENTS=$(< "$CUSTOM_CONFIG_FILENAME")

# Run hoominer in a screen session
if [[ "$CONFIG_CONTENTS" == *"--hoominer"* ]]; then
    ./hoominer $CONFIG_CONTENTS &
fi

if [[ "$CONFIG_CONTENTS" == *"--hoo_cpu"* ]]; then
    ./hoo_cpu $CONFIG_CONTENTS &
fi

if [[ "$CONFIG_CONTENTS" == *"--hoo_gpu"* ]]; then
    ./hoo_gpu $CONFIG_CONTENTS &
fi

wait  # Wait for all background processes to finish
