#!/bin/bash
# Runs Hoominer, Hoo-CPU, and Hoo-GPU in parallel in separate screen sessions with appended worker names (_minername)

. h-manifest.conf

mkdir -p "$(dirname "$CUSTOM_LOG_BASENAME.log")" && touch "$CUSTOM_LOG_BASENAME.log"

CONFIG_CONTENTS=$(< "$CUSTOM_CONFIG_FILENAME")

# Function to append miner name to workername (using underscore)
set_worker_name() {
    local config="$1"
    local miner_name="$2"

    # Case 1: Has worker name (dot after hash)
    if echo "$config" | grep -qE '--user[[:space:]]+hoosat:[0-9a-fA-F]{64}\.'; then
        # Append _minername to existing worker
        echo "$config" | sed -E "s/(--user[[:space:]]+hoosat:[0-9a-fA-F]{64}\.[^[:space:]]*)/\1_${miner_name}/"
    # Case 2: No worker name (just hash)
    elif echo "$config" | grep -qE '--user[[:space:]]+hoosat:[0-9a-fA-F]{64}([[:space:]]|$)'; then
        # Add new worker name with underscore
        echo "$config" | sed -E "s/(--user[[:space:]]+hoosat:[0-9a-fA-F]{64})/\1_${miner_name}/"
    else
        # No valid --user found; leave config unchanged
        echo "$config"
    fi
}

# --- Run miners in parallel ---
if [[ "$CONFIG_CONTENTS" == *"--hoominer"* ]]; then
    hoominer_config=$(set_worker_name "$CONFIG_CONTENTS" "hoominer")
    ./hoominer $hoominer_config &
fi

if [[ "$CONFIG_CONTENTS" == *"--hoo_cpu"* ]]; then
    hoo_cpu_config=$(set_worker_name "$CONFIG_CONTENTS" "hoo_cpu")
    ./hoo_cpu $hoo_cpu_config &
fi

if [[ "$CONFIG_CONTENTS" == *"--hoo_gpu"* ]]; then
    hoo_gpu_config=$(set_worker_name "$CONFIG_CONTENTS" "hoo_gpu")
    ./hoo_gpu $hoo_gpu_config &
fi

wait  # Wait for all background processes to finish
