#!/usr/bin/env bash

cat /hive-config/wallet.conf > wallet.conf

# Function to extract value after = and remove quotes
get_config() {
    grep "^$1=" /hive-config/wallet.conf | cut -d'=' -f2- | sed -e "s/^['\"]//; s/['\"]$//"
}

TEMPLATE=$(get_config 'CUSTOM_TEMPLATE')
USERNAME=$(echo "$TEMPLATE" | cut -d'.' -f1)
WORKER=$(echo "$TEMPLATE" | cut -d'.' -f2)

PASS=$(get_config 'CUSTOM_PASS')
EXTRA_CONFIG=$(get_config 'CUSTOM_USER_CONFIG')
CUSTOM_URL=$(get_config 'CUSTOM_URL')

echo "Username: $USERNAME" > setup.txt
echo "Worker: $WORKER" >> setup.txt
echo "Password: $PASS" >> setup.txt
echo "Extra config: $EXTRA_CONFIG" >> setup.txt
echo "Custom URL: $CUSTOM_URL" >> setup.txt

HOO_GPU_ARGS=" -o $CUSTOM_URL -u $USERNAME.$WORKER -p $PASS $EXTRA_CONFIG "

echo "Whole string to pass as args $HOO_GPU_ARGS" >> setup.txt
